*! version 5.0
* 13 August 2018
* NIDS

* THIS IS A RENT EXPENDITURE DO FILE: 13 OF 14

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "W1 Rent Expenditure - Master Rent Expenditure (12 of 14).do"

*=====================================================================================================================================
* SETTING UP STATA TO RUN DO FILES

clear
cap clear matrix
set more off 

version 12.0

*-------------------------------------------------------------------------------------------------------------------------------------

use "$DataIN\HHQuestionnaire_$VersionIN.dta", clear
sort w1_hhid
merge 1:1 w1_hhid using "$DataIN\hhderived_$VersionIN.dta"
drop if _merge == 2
drop _merge

sort w1_hhid
merge 1:m w1_hhid using "$DataIN\indderived_$VersionIN.dta", keepusing(w1_best_race w1_best_edu w1_best_age_yrs)
drop if _merge == 2
drop _merge

egen majpop =mode(w1_best_race), minmode by(w1_hhid)
recode  w1_best_edu (25=0)(25/999=.)
egen maxed = max(w1_best_edu), by(w1_hhid)
egen maxage=max(w1_best_age_yrs), by(w1_hhid)
gen ageunder15=w1_best_age_yrs<15
egen hhchildren=sum(ageunder15), by(w1_hhid)
gen fammatric=maxed>11
gen famtert=maxed>20
gen famprim=maxed<7
tab majpop, gen(race)
rename race1 African
rename race2 Coloured
rename race3 Asian
rename race4 White

sort w1_hhid
duplicates drop w1_hhid, force

**********************************************************************
***	Creates dummy variables for province and geographic area for the household
**********************************************************************

quietly tab w1_prov2011, gen(province_d)
rename province_d1 westerncape
rename province_d2 easterncape
rename province_d3 northerncape
rename province_d4 freestate
rename province_d5 kwazulunatal
rename province_d6 northwest
rename province_d7 gauteng
rename province_d8 mpumalanga
rename province_d9 limpopo

recode w1_geo2011 (1/2=1 "Rural") (4/5=2 "Urban") (3=3 "Tribal"), gen(geoarea)
recode geoarea (1=1 "RURAL") (2/3=0 "Non-RURAL"), gen(rural)
recode geoarea (1/2=0 "Non-Tribal") (3=1 "TRIBAL"), gen(tribal)
recode geoarea (1=0 "Non-Urban") (2=1 "URBAN") (3=0), gen(urban)

save "$DataOUT\tempdata.dta", replace											//Saves the data as a temporary dataset
